<?php

namespace Import\ApiBundle\Services\Allegro;

use Import\ApiBundle\Entity\AllegroCategory;
use Import\ApiBundle\Entity\AllegroCategoryItem;
use Import\ApiBundle\Services\DataStructure\AllegroDoShowCatDataStructure;

class AllegroImportCategoryItems extends AllegroMainService
{
    protected $type = 'AllegroImportCategoryItems';

    private $countAll = 0;
    private $countAdd = 0;
    private $durationItems = null;

    //('root_cat_id','type_id')
    private $types = array(20782 => 1, 3 => 2, 2 => 3, 4 => 4);
    private $AllegroCategoryItemType;

    public function __construct(\Symfony\Component\DependencyInjection\Container $Container)
    {
        parent::__construct($Container);
    }

    public function import($durationItems = null)
    {
        $this->durationItems = $durationItems;
        echo "\r\n";

        if($this->durationItems)
        {
            echo 'DURATION='.$this->durationItems."\r\n";
        }

        $this->importEstate();
        $this->importMOTO();
        $this->importKOMP();
        $this->importPHONE();
        $this->importOTHER();

        return array('count' => 0);
    }

    //Nieruchomości
    public function importEstate()
    {
        $this->AllegroCategoryItemType = $this->getAllegroCategoryItemType('Nieruchomości');
        $rootCategoryId = 20782;    //Nieruchomości
        $categoryIds = array(
            112745,     //Mieszkania do wynajęcia(id=4116)
            112746,     //Domy do wynajęcia(id=4850)
            112747,     //Pokoje do wynajęcia(id=5586)
            112749,     //Lokale i obiekty użytkowe do wynajęcia(id=6755)
            112750     //Magazyny i hale do wynajęcia(id=7491)
        );

        $categoryIdsProvince = array(
            116888,     //Mieszkania do wynajęcia/Podkarpackie(id=4440)
            117621,     //Domy do wynajęcia/Podkarpackie(id=5177)
            118356,     //Pokoje do wynajęcia/Podkarpackie(id=5830)
            119523,     //Lokale i obiekty użytkowe do wynajęcia/Podkarpackie(id=7082)
            120258     //Magazyny i hale do wynajęcia/Podkarpackie(id=7735)
        );


//        $ids = array(486,491,62998,165,589,590,4029);
//        $ids = array(486);

//        foreach($ids as $categoryId)
        foreach($categoryIdsProvince as $categoryId)
        {
            $this->getItemsFromCategory($categoryId);
        }

        return array('count' => 0);
    }

    public function importMOTO()
    {
        $this->AllegroCategoryItemType = $this->getAllegroCategoryItemType('Pojazdy');
        //samochody - 149
        $categoryIds = array(
            4029,     //Osobowe
            590,     //Dostawcze
        );
        $categoryIdsParts = array(
//            4035,//Fiat
//            4036,//Ford
//            4037,//Honda
//            18193,//Hummer
//            4038,//Hyundai
//            18197,//Infiniti
//            12403,//Isuzu
//            8641,//Jaguar
//            12404,//Jeep
//            8642,//Kia
//            57982,//Lamborghini
        );

//        foreach($categoryIdsParts as $categoryId)
        foreach($categoryIds as $categoryId)
        {
            $this->getItemsFromCategory($categoryId);
        }
    }

    public function importKOMP()
    {
        $this->AllegroCategoryItemType = $this->getAllegroCategoryItemType('Komputery');
        $categoryIds = array(
            4578,   //Drukarki i skanery
            486,    //Komputery stacjonarne
            491,    //Laptopy
            62998,  //Netbooki
            68,     //Oprogramowanie
            9060,   //Serwery i SCSI
            121202,  //Tablety->Urządzenia
        );
        $categoryIdsParts = array(
            4579, //Drukarki atramentowe
            4582, //Drukarki igłowe
            4584, //Drukarki laserowe
            10882,   //Urządzenia wielofunkcyjne
            130502, //Drukarki 3D
            8634, //Drukarki inne
            4586, //Plotery
            4587, //Skanery
            17252, //Papiery, folie
        );

//        foreach($categoryIdsParts as $categoryId)
        foreach($categoryIds as $categoryId)
        {
            $this->getItemsFromCategory($categoryId);
        }
    }

    public function importPHONE()
    {
        $this->AllegroCategoryItemType = $this->getAllegroCategoryItemType('Telefony');
        //15675
        $categoryIds = array(
            165,    //telefony komórkowe
            240,    //urządzenia stacjonarme
        );
        $categoryIdsParts = array(
            4937,//Alcatel
            48978,//Apple
            50971,//Blackberry
            16618,//HTC
            125154,//Huawei
            146538,//Lenovo
            10539,//LG
            4941,//Motorola
            70568,//myPhone
            4978,//Nokia
            435,//Samsung
            5021,//Siemens
            121183,//Sony
            5044,//Sony Ericsson
            127376,//ZTE
            170,//Inne marki
            85889,//Zestawy
//            50999,//Uszkodzone
        );

//        foreach($categoryIdsParts as $categoryId)
        foreach($categoryIds as $categoryId)
        {
            $this->getItemsFromCategory($categoryId);
        }
    }

    public function importOTHER()
    {
        $this->AllegroCategoryItemType = $this->getAllegroCategoryItemType('Inne');
        $categoryIds = array(
//            4029,     //osobowe(id=9690)
        );

        foreach($categoryIds as $categoryId)
        {
            $this->getItemsFromCategory($categoryId);
        }
    }

    private function getItemsFromCategory($AllegroCategoryId)
    {
        echo "\r\n";
        $AllegroCategory = $this->getAllegroCategory($AllegroCategoryId);
        if(empty($AllegroCategory))
        {
            echo 'WARNING: Not exist Category - '.$AllegroCategoryId."\r\n";
            return false;
        }
        $this->echoAllegroCategory($AllegroCategory);

        $DoShowCatDataStructure = new AllegroDoShowCatDataStructure();
        $DoShowCatDataStructure->sessionHandle = $this->allegroClient->session['session-handle-part'];
        $DoShowCatDataStructure->catId = $AllegroCategory->getCatId();

        if($this->durationItems > 0)
        {
            $DoShowCatDataStructure->catItemDurationOption->durationOption = 1;
            $DoShowCatDataStructure->catItemDurationOption->durationValue = $this->durationItems;
        }

        $dataItems = $this->allegroClient->showCat($DoShowCatDataStructure);
        echo ' - Count='.$dataItems['cat-items-count'];

        if(count($dataItems['cat-child-array']) > 0)
        {
            foreach ($dataItems['cat-child-array'] as $child)
            {
                if($child->{'cat-items-count'} > 0)
                {
                    $this->getItemsFromCategory($child->{'cat-id'});
                }
            }
        }
        else
        {
            $count = $this->saveItems($dataItems['cat-items-array']);

            $this->countAll += $dataItems['cat-items-count'];
            $this->countAdd += $count;
            echo '(Add='.$count.') - (All='.$this->countAll.',Add='.$this->countAdd.')';
        }
        unset($DoShowCatDataStructure);
    }

    private function echoAllegroCategory(AllegroCategory $AllegroCategory)
    {
        for($i=0;$i<$AllegroCategory->getLvl();$i++)
        {
            echo '  ';
        }
        echo 'id='.$AllegroCategory->getId().',catId='.$AllegroCategory->getCatId().',Title='.$AllegroCategory->getTitle();
    }

    private function saveItems($itemsArray)
    {
        $count = 0;
        foreach($itemsArray as $item)
        {
            $item->{'AllegroCategoryItemType'} = $this->AllegroCategoryItemType;
            $newItem = $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategoryItem')->addFromAllegroStructure($item);
            if(!empty($newItem))
            {
                $count++;
            }
        }
        if($count > 0)
        {
            $this->getDoctrine()->getManager()->flush();
//            $this->getDoctrine()->getManager()->clear();
        }

        return $count;
    }

    private function getAllegroCategory($cat_id)
    {
        return $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategory')->findOneBy(array('cat_id' => $cat_id));
    }
}